
###read excelFile
install.packages("xlsx")
install.packages("xlsxjars")
install.packages("rJava")
install.packages("readxl")
install.packages("openxlsx")
install.packages("writexl")
install.packages("qpcR")

library(xlsx)
library(qpcR)
library(rJava)
library(xlsx)
library(readxl)
library(writexl)
library(ggplot2)
library(xlsxjars)
library(openxlsx)


metadata.dys<- read.xlsx("C://Users/bararpou/Desktop/Studies/HTAN/Metabolomics/NEW_ANALYSIS/Dys_catagory/MetaData.xlsx",
                 sheet="Sheet1", rowNames = FALSE)

data.dys<- read.xlsx("C://Users/bararpou/Desktop/Studies/HTAN/Metabolomics/NEW_ANALYSIS/Dys_catagory/Metabolomics_correctedMedianNormalized.xlsx",
                         sheet="Sheet2", rowNames = FALSE)

data.dys<- read.xlsx("C://Users/bararpou/Desktop/Studies/HTAN/Metabolomics/NEW_ANALYSIS/Dys_catagory/Metabolomics_correctedMedianNormalized.xlsx",
                     sheet="valid_met", rowNames = FALSE)

order.metadata.dys <- metadata.dys[order(metadata.dys$row.names),]
order.data.dys <- data.dys[order(data.dys$row.names),]


meta.B.N<-order.metadata.dys[!(order.metadata.dys$Dys=="Y"), ]

meta.Dys.N<-order.metadata.dys[!(order.metadata.dys$Dys=="B"), ]

meta.Dys.B<-order.metadata.dys[!(order.metadata.dys$Dys=="N"), ]


###select subset
library(data.table)
data.BN<-subset(order.data.dys, row.names %in% meta.B.N$row.names)
BN.data<-data.frame(meta.B.N,data.BN[-1],row.names = TRUE)
write.csv(BN.data,file = "BN.data2.csv")
###########
BN.data<-BN.data[,-1092]
BN.data<-BN.data[,-1883]
#######################33
###select dys vs normal group
library(data.table)
data.DysN<-subset(order.data.dys, row.names %in% meta.Dys.N$row.names)
DysN.data<-data.frame(meta.Dys.N,data.DysN[-1],row.names = TRUE)
write.csv(DysN.data,file = "DysN.data.csv")

######################
###select dys vs B group
library(data.table)
data.DysB<-subset(order.data.dys, row.names %in% meta.Dys.B$row.names)
DysB.data<-data.frame(meta.Dys.B,data.DysB[-1],row.names = TRUE)
write.csv(DysB.data,file = "C://Users/bararpou/Desktop/Studies/HTAN/Metabolomics/NEW_ANALYSIS/Dys_catagory/DysB/DysB.data2.csv")



##########################################

## primary GLMM-fitting packages:
library("lme4")
library("glmmADMB")      ## (not on CRAN)
library("glmmTMB")
library("MCMCglmm")
library("blme")
library("MASS")          ## for glmmPQL (base R)
library("nlme")          ## for intervals(), tundra example (base R)
library(MuMIn)

library(nlme)
library(lme4)

library(lme4)
library("performance")
install.packages("rstanarm")
library(rstanarm)
  set.seed(1011)

seq(700000000)
options(max.print=999999)
sink("GlmerMetabolomics_BN_ANOVA2.txt")
for (i in 9:3845) {
  print(names(BN.data)[i])
  model.01<-glmer(as.factor(BN.data$dys_cat) ~ BN.data[,i] + sex+ age+(1|patient) ,verbose = 2,
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= BN.data,family="binomial")

  model.00<-glmer(as.factor(BN.data$dys_cat) ~ sex+ age +(1|patient) ,verbose = 2,
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= BN.data,family="binomial")
  print(anova(model.01,model.00))

}

sink()
###############################3
seq(700000000)
set.seed(40)
options(max.print=999999)
sink("GlmerMetabolomics_BN_Coef2.txt")
for (i in 9:3845) {
  print(names(BN.data)[i])
  model.01<-glmer(as.factor(BN.data$dys_cat) ~ BN.data[,i] + sex+ age+(1|patient),
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= BN.data,family="binomial")

  print(summary(model.01)$coef)

}
sink()
######################
set.seed(40)
options(max.print=999999)
sink("GlmerMetabolomics_BN_summary.txt")
for (i in 9:3845) {
  print(names(BN.data)[i])
  model.01<-glmer(as.factor(BN.data$dys_cat) ~ BN.data[,i] + sex+ age+(1|patient),
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= BN.data,family="binomial")

  print(summary(model.01), corr=F)
  print(icc(model.01))
  print(model_performance(model.01))
  print(r2(model.01))
  print(confint(model.01))
}
sink()
############################
##########################################Dys vs Normal
seq(700000000)
options(max.print=999999)
sink("GlmerMetabolomics_DysN_ANOVA.txt")
for (i in 9:3846) {
  print(names(DysN.data)[i])
  model.01<-glmer(as.factor(DysN.data$dys_cat) ~ DysN.data[,i] + sex+ age+(1|patient) ,verbose = 2,
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= DysN.data,family="binomial")

  model.00<-glmer(as.factor(DysN.data$dys_cat) ~ sex+ age +(1|patient) ,verbose = 2,
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= DysN.data,family="binomial")
  print(anova(model.01,model.00))

}

sink()
###############################3
seq(700000000)
set.seed(40)
options(max.print=999999)
sink("lmerMetabolomics_DysN_Coef.txt")
for (i in 9:3839) {
  print(names(DysN.data)[i])
  model.01<-glmer(as.factor(DysN.data$dys_cat) ~ DysN.data[,i] + sex+ age+(1|patient),
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= DysN.data,family="binomial")

  print(summary(model.01)$coef)

}
sink()
######################
set.seed(40)
options(max.print = .Machine$integer.max)
sink("GlmerMetabolomics_DysN_summary2.txt")
for (i in 9:3839) {
  print(names(DysN.data)[i])
  model.01<-glmer(as.factor(DysN.data$dys_cat) ~ DysN.data[,i] + sex+ age+(1|patient),
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= DysN.data,family="binomial")
  library(piecewiseSEM)
  library(r2glmm)
  library(MuMIn)
  library(glmnet)
  library(rstanarm)
  library(performance)
  print(summary(model.01), corr=F)
  print(icc(model.01))
  print(model_performance(model.01))
  print(r2(model.01))
  print(confint(model.01))
}
sink()
############################
######################################Dys vs Bengin
seq(700000000)
options(max.print = .Machine$integer.max)
sink("C://Users/bararpou/Desktop/Studies/HTAN/Metabolomics/NEW_ANALYSIS/Dys_catagory/DysB/GlmerMet_DysN_ANOVA.txt")
for (i in 9:3839) {
  print(names(DysB.data)[i])
  model.01<-glmer(as.factor(DysB.data$dys_cat) ~ DysB.data[,i] + sex+ age+(1|patient) ,verbose = 2,
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= DysB.data,family="binomial")

  model.00<-glmer(as.factor(DysB.data$dys_cat) ~ sex+ age +(1|patient) ,verbose = 1,
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= DysB.data,family="binomial")
  print(anova(model.01,model.00))

}

sink()
###############################3
seq(700000000)
set.seed(40)
options(max.print=999999)
options(max.print = .Machine$integer.max)
sink("C://Users/bararpou/Desktop/Studies/HTAN/Metabolomics/NEW_ANALYSIS/Dys_catagory/DysB/GlmerMet_DysN_Coef.txt")
for (i in 9:3839) {
  print(names(DysB.data)[i])
  model.01<-glmer(as.factor(DysB.data$dys_cat) ~ DysB.data[,i] + sex+ age+(1|patient),verbose = 1,
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= DysB.data,family="binomial")

  print(summary(model.01)$coef)

}
sink()
######################
library(lmerTest)
set.seed(40)
options(max.print = .Machine$integer.max)
sink("C://Users/bararpou/Desktop/Studies/HTAN/Metabolomics/NEW_ANALYSIS/Dys_catagory/DysB/GlmerMetDysN_summary.txt")
for (i in 9:3846) {
  print(names(DysB.data)[i])
  model.01<-glmer(as.factor(DysB.data$dys_cat) ~ DysB.data[,i] + sex+ age+(1|patient),verbose = 1,
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= DysB.data,family="binomial")
  library(piecewiseSEM)
  library(r2glmm)
  library(MuMIn)
  library(glmnet)
  library(rstanarm)
  library(performance)
  print(summary(model.01), corr=F)
  print(icc(model.01))
  print(model_performance(model.01))
  print(r2(model.01))
  #print(confint(model.01))
}
sink()

##################################

data<- read.csv("C://Users/bararpou/Desktop/Studies/HTAN/Metabolomics/NEW_ANALYSIS/Dys_catagory/BN/BN_data2.csv",
                sep = ",",header = T, row.names = 1)

data<- read.csv("C://Users/bararpou/Desktop/Studies/HTAN/Metabolomics/NEW_ANALYSIS/Dys_catagory/DysB/DysB.data2.csv",
                sep = ",",header = T, row.names = 1)

#to check confidence level
set.seed(40)
options(max.print = .Machine$integer.max)
sink("C://Users/bararpou/Desktop/Studies/HTAN/Metabolomics/NEW_ANALYSIS/Dys_catagory/DysB/GlmerMetDysB_CI2.txt")
for (i in 9:3846) {
  print(names(data)[i])
  model.01<-glmer(as.factor(data$dys_cat) ~ data[,i] + sex+ age+(1|patient),verbose = 1,
                  control=glmerControl(optimizer="bobyqa",
                                       optCtrl = list(maxfun = 100000)),nAGQ=9, data= data,family="binomial")

  #print(summary(model.01), corr=F)
  se <- sqrt(diag(vcov(model.01)))
  # table of estimates with 95% CI
  tab <- cbind(Est = fixef(model.01), LL = fixef(model.01) - 1.96 * se, UL = fixef(model.01) + 1.96 * se)
  print(tab)
}
sink()
